/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.RenderText;

public class GUIComponentItem
extends AGUIComponent {
    public final float scale;
    public IWrapperItemStack stack;
    public List<IWrapperItemStack> stacks;
    public IWrapperItemStack stackToRender;
    public final Point3D translation = new Point3D();

    public GUIComponentItem(int x, int y, float scale) {
        super(x, y, (int)(16.0f * scale), (int)(16.0f * scale));
        this.scale = scale;
        this.textPosition.set(this.position.x + (double)(scale * 16.0f), this.position.y - (double)(16.0f * scale) + (double)(scale * 8.0f), this.textPosition.z);
    }

    public GUIComponentItem(GUIComponentButton linkedButton) {
        this(linkedButton.constructedX + 1, linkedButton.constructedY + 1, 1.0f);
    }

    @Override
    public int getZOffset() {
        return 100;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (this.stack != null) {
            this.stackToRender = this.stack;
        } else if (this.stacks != null && !this.stacks.isEmpty()) {
            this.stackToRender = this.stacks.get((int)(System.currentTimeMillis() % (long)(this.stacks.size() * 500) / 500L));
        } else {
            this.stackToRender = null;
            this.text = null;
        }
        if (this.stackToRender != null) {
            this.translation.set(this.position);
            InterfaceManager.renderingInterface.renderItemModel(this);
            this.text = this.stackToRender.getSize() > 1 ? '\u00a7' + String.valueOf('l') + this.stackToRender.getSize() : null;
        }
    }

    @Override
    public void renderText(boolean renderTextLit, int worldLightValue) {
        RenderText.drawText(this.text, null, this.textPosition, ColorRGB.WHITE, RenderText.TextAlignment.RIGHT_ALIGNED, this.scale, false, 0, renderTextLit, worldLightValue);
    }

    @Override
    public List<String> getTooltipText() {
        if (this.stackToRender != null && !this.stackToRender.isEmpty()) {
            return InterfaceManager.clientInterface.getTooltipLines(this.stackToRender);
        }
        return null;
    }
}

